@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this information, CDN can apply scenario driven optimization.
 */
public enum class OptimizationType(
    public val javaValue: com.pulumi.azurenative.cdn.enums.OptimizationType,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.OptimizationType> {
    GeneralWebDelivery(com.pulumi.azurenative.cdn.enums.OptimizationType.GeneralWebDelivery),
    GeneralMediaStreaming(com.pulumi.azurenative.cdn.enums.OptimizationType.GeneralMediaStreaming),
    VideoOnDemandMediaStreaming(com.pulumi.azurenative.cdn.enums.OptimizationType.VideoOnDemandMediaStreaming),
    LargeFileDownload(com.pulumi.azurenative.cdn.enums.OptimizationType.LargeFileDownload),
    DynamicSiteAcceleration(com.pulumi.azurenative.cdn.enums.OptimizationType.DynamicSiteAcceleration),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.OptimizationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.OptimizationType):
            OptimizationType = OptimizationType.values().first { it.javaValue == javaType }
    }
}
