@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Name of the pricing tier.
 */
public enum class SkuName(
    public val javaValue: com.pulumi.azurenative.cdn.enums.SkuName,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.SkuName> {
    Standard_Verizon(com.pulumi.azurenative.cdn.enums.SkuName.Standard_Verizon),
    Premium_Verizon(com.pulumi.azurenative.cdn.enums.SkuName.Premium_Verizon),
    Custom_Verizon(com.pulumi.azurenative.cdn.enums.SkuName.Custom_Verizon),
    Standard_Akamai(com.pulumi.azurenative.cdn.enums.SkuName.Standard_Akamai),
    Standard_ChinaCdn(com.pulumi.azurenative.cdn.enums.SkuName.Standard_ChinaCdn),
    Standard_Microsoft(com.pulumi.azurenative.cdn.enums.SkuName.Standard_Microsoft),
    Standard_AzureFrontDoor(com.pulumi.azurenative.cdn.enums.SkuName.Standard_AzureFrontDoor),
    Premium_AzureFrontDoor(com.pulumi.azurenative.cdn.enums.SkuName.Premium_AzureFrontDoor),
    Standard_955BandWidth_ChinaCdn(com.pulumi.azurenative.cdn.enums.SkuName.Standard_955BandWidth_ChinaCdn),
    Standard_AvgBandWidth_ChinaCdn(com.pulumi.azurenative.cdn.enums.SkuName.Standard_AvgBandWidth_ChinaCdn),
    StandardPlus_ChinaCdn(com.pulumi.azurenative.cdn.enums.SkuName.StandardPlus_ChinaCdn),
    StandardPlus_955BandWidth_ChinaCdn(com.pulumi.azurenative.cdn.enums.SkuName.StandardPlus_955BandWidth_ChinaCdn),
    StandardPlus_AvgBandWidth_ChinaCdn(com.pulumi.azurenative.cdn.enums.SkuName.StandardPlus_AvgBandWidth_ChinaCdn),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.SkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.SkuName): SkuName =
            SkuName.values().first { it.javaValue == javaType }
    }
}
