@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes what transforms are applied before matching
 */
public enum class Transform(
    public val javaValue: com.pulumi.azurenative.cdn.enums.Transform,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.Transform> {
    Lowercase(com.pulumi.azurenative.cdn.enums.Transform.Lowercase),
    Uppercase(com.pulumi.azurenative.cdn.enums.Transform.Uppercase),
    Trim(com.pulumi.azurenative.cdn.enums.Transform.Trim),
    UrlDecode(com.pulumi.azurenative.cdn.enums.Transform.UrlDecode),
    UrlEncode(com.pulumi.azurenative.cdn.enums.Transform.UrlEncode),
    RemoveNulls(com.pulumi.azurenative.cdn.enums.Transform.RemoveNulls),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.Transform = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.Transform): Transform =
            Transform.values().first { it.javaValue == javaType }
    }
}
