@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Match variable to compare against.
 */
public enum class WafMatchVariable(
    public val javaValue: com.pulumi.azurenative.cdn.enums.WafMatchVariable,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.WafMatchVariable> {
    RemoteAddr(com.pulumi.azurenative.cdn.enums.WafMatchVariable.RemoteAddr),
    SocketAddr(com.pulumi.azurenative.cdn.enums.WafMatchVariable.SocketAddr),
    RequestMethod(com.pulumi.azurenative.cdn.enums.WafMatchVariable.RequestMethod),
    RequestHeader(com.pulumi.azurenative.cdn.enums.WafMatchVariable.RequestHeader),
    RequestUri(com.pulumi.azurenative.cdn.enums.WafMatchVariable.RequestUri),
    QueryString(com.pulumi.azurenative.cdn.enums.WafMatchVariable.QueryString),
    RequestBody(com.pulumi.azurenative.cdn.enums.WafMatchVariable.RequestBody),
    Cookies(com.pulumi.azurenative.cdn.enums.WafMatchVariable.Cookies),
    PostArgs(com.pulumi.azurenative.cdn.enums.WafMatchVariable.PostArgs),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.WafMatchVariable = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.WafMatchVariable):
            WafMatchVariable = WafMatchVariable.values().first { it.javaValue == javaType }
    }
}
