@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.ActivatedResourceReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to another resource along with its state.
 * @property id Resource ID.
 */
public data class ActivatedResourceReferenceArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.ActivatedResourceReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.ActivatedResourceReferenceArgs =
        com.pulumi.azurenative.cdn.inputs.ActivatedResourceReferenceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActivatedResourceReferenceArgs].
 */
@PulumiTagMarker
public class ActivatedResourceReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("ndpxhroyeueudvpl")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("lnodlhvjdsbwfwgt")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ActivatedResourceReferenceArgs = ActivatedResourceReferenceArgs(
        id = id,
    )
}
