@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.CompressionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * settings for compression.
 * @property contentTypesToCompress List of content types on which compression applies. The value should be a valid MIME type.
 * @property isCompressionEnabled Indicates whether content compression is enabled on AzureFrontDoor. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
 */
public data class CompressionSettingsArgs(
    public val contentTypesToCompress: Output<List<String>>? = null,
    public val isCompressionEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.CompressionSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.CompressionSettingsArgs =
        com.pulumi.azurenative.cdn.inputs.CompressionSettingsArgs.builder()
            .contentTypesToCompress(
                contentTypesToCompress?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .isCompressionEnabled(isCompressionEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CompressionSettingsArgs].
 */
@PulumiTagMarker
public class CompressionSettingsArgsBuilder internal constructor() {
    private var contentTypesToCompress: Output<List<String>>? = null

    private var isCompressionEnabled: Output<Boolean>? = null

    /**
     * @param value List of content types on which compression applies. The value should be a valid MIME type.
     */
    @JvmName("gnejtkhjnxdfyofa")
    public suspend fun contentTypesToCompress(`value`: Output<List<String>>) {
        this.contentTypesToCompress = value
    }

    @JvmName("uuqvgxjqrofqujgg")
    public suspend fun contentTypesToCompress(vararg values: Output<String>) {
        this.contentTypesToCompress = Output.all(values.asList())
    }

    /**
     * @param values List of content types on which compression applies. The value should be a valid MIME type.
     */
    @JvmName("vshafrtsrtfteyso")
    public suspend fun contentTypesToCompress(values: List<Output<String>>) {
        this.contentTypesToCompress = Output.all(values)
    }

    /**
     * @param value Indicates whether content compression is enabled on AzureFrontDoor. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
     */
    @JvmName("njwrsgsthosliarq")
    public suspend fun isCompressionEnabled(`value`: Output<Boolean>) {
        this.isCompressionEnabled = value
    }

    /**
     * @param value List of content types on which compression applies. The value should be a valid MIME type.
     */
    @JvmName("vqaokpflgnfhxsyd")
    public suspend fun contentTypesToCompress(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentTypesToCompress = mapped
    }

    /**
     * @param values List of content types on which compression applies. The value should be a valid MIME type.
     */
    @JvmName("ftqnpungajiykiaj")
    public suspend fun contentTypesToCompress(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentTypesToCompress = mapped
    }

    /**
     * @param value Indicates whether content compression is enabled on AzureFrontDoor. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
     */
    @JvmName("vwuwaocwffprhdoi")
    public suspend fun isCompressionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isCompressionEnabled = mapped
    }

    internal fun build(): CompressionSettingsArgs = CompressionSettingsArgs(
        contentTypesToCompress = contentTypesToCompress,
        isCompressionEnabled = isCompressionEnabled,
    )
}
