@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.CookiesMatchConditionParametersArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.CookiesOperator
import com.pulumi.azurenative.cdn.kotlin.enums.Transform
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the parameters for Cookies match conditions
 * @property matchValues The match value for the condition of the delivery rule
 * @property negateCondition Describes if this is negate condition or not
 * @property operator Describes operator to be matched
 * @property selector Name of Cookies to be matched
 * @property transforms List of transforms
 * @property typeName
 */
public data class CookiesMatchConditionParametersArgs(
    public val matchValues: Output<List<String>>? = null,
    public val negateCondition: Output<Boolean>? = null,
    public val `operator`: Output<Either<String, CookiesOperator>>,
    public val selector: Output<String>? = null,
    public val transforms: Output<List<Either<String, Transform>>>? = null,
    public val typeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.CookiesMatchConditionParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.CookiesMatchConditionParametersArgs =
        com.pulumi.azurenative.cdn.inputs.CookiesMatchConditionParametersArgs.builder()
            .matchValues(matchValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .negateCondition(negateCondition?.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .selector(selector?.applyValue({ args0 -> args0 }))
            .transforms(
                transforms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .typeName(typeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CookiesMatchConditionParametersArgs].
 */
@PulumiTagMarker
public class CookiesMatchConditionParametersArgsBuilder internal constructor() {
    private var matchValues: Output<List<String>>? = null

    private var negateCondition: Output<Boolean>? = null

    private var `operator`: Output<Either<String, CookiesOperator>>? = null

    private var selector: Output<String>? = null

    private var transforms: Output<List<Either<String, Transform>>>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value The match value for the condition of the delivery rule
     */
    @JvmName("axuyoqasbovrvmhx")
    public suspend fun matchValues(`value`: Output<List<String>>) {
        this.matchValues = value
    }

    @JvmName("eodahraxjdswxvbm")
    public suspend fun matchValues(vararg values: Output<String>) {
        this.matchValues = Output.all(values.asList())
    }

    /**
     * @param values The match value for the condition of the delivery rule
     */
    @JvmName("aiseuneifinvhdpu")
    public suspend fun matchValues(values: List<Output<String>>) {
        this.matchValues = Output.all(values)
    }

    /**
     * @param value Describes if this is negate condition or not
     */
    @JvmName("tcffgupyiufocygl")
    public suspend fun negateCondition(`value`: Output<Boolean>) {
        this.negateCondition = value
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("mldcfuypwuorppji")
    public suspend fun `operator`(`value`: Output<Either<String, CookiesOperator>>) {
        this.`operator` = value
    }

    /**
     * @param value Name of Cookies to be matched
     */
    @JvmName("okxpsujgdiqpqvjs")
    public suspend fun selector(`value`: Output<String>) {
        this.selector = value
    }

    /**
     * @param value List of transforms
     */
    @JvmName("mjjfrwougwitikha")
    public suspend fun transforms(`value`: Output<List<Either<String, Transform>>>) {
        this.transforms = value
    }

    @JvmName("kpancnmyojwafrmt")
    public suspend fun transforms(vararg values: Output<Either<String, Transform>>) {
        this.transforms = Output.all(values.asList())
    }

    /**
     * @param values List of transforms
     */
    @JvmName("amajgapokvotfkan")
    public suspend fun transforms(values: List<Output<Either<String, Transform>>>) {
        this.transforms = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("wdkrhxujtotovjxd")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value The match value for the condition of the delivery rule
     */
    @JvmName("omkrpkhhdujbiapw")
    public suspend fun matchValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchValues = mapped
    }

    /**
     * @param values The match value for the condition of the delivery rule
     */
    @JvmName("rqcuupqfojrbrnji")
    public suspend fun matchValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchValues = mapped
    }

    /**
     * @param value Describes if this is negate condition or not
     */
    @JvmName("lnmxajqbjorxxdca")
    public suspend fun negateCondition(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negateCondition = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("fyuffxrjoqvqqpve")
    public suspend fun `operator`(`value`: Either<String, CookiesOperator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("fhfoalyigwfbcfxy")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CookiesOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("scqvkhiilwcttmpm")
    public fun `operator`(`value`: CookiesOperator) {
        val toBeMapped = Either.ofRight<String, CookiesOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Name of Cookies to be matched
     */
    @JvmName("rqtwscjljxhrjurx")
    public suspend fun selector(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selector = mapped
    }

    /**
     * @param value List of transforms
     */
    @JvmName("fpvavuftbflhggkl")
    public suspend fun transforms(`value`: List<Either<String, Transform>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param values List of transforms
     */
    @JvmName("oqlquhagpisloeid")
    public suspend fun transforms(vararg values: Either<String, Transform>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param value
     */
    @JvmName("femirvxjucayqdni")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): CookiesMatchConditionParametersArgs = CookiesMatchConditionParametersArgs(
        matchValues = matchValues,
        negateCondition = negateCondition,
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        selector = selector,
        transforms = transforms,
        typeName = typeName ?: throw PulumiNullFieldException("typeName"),
    )
}
