@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.CustomRuleListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines contents of custom rules
 * @property rules List of rules
 */
public data class CustomRuleListArgs(
    public val rules: Output<List<CustomRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.CustomRuleListArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.CustomRuleListArgs =
        com.pulumi.azurenative.cdn.inputs.CustomRuleListArgs.builder()
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomRuleListArgs].
 */
@PulumiTagMarker
public class CustomRuleListArgsBuilder internal constructor() {
    private var rules: Output<List<CustomRuleArgs>>? = null

    /**
     * @param value List of rules
     */
    @JvmName("ixsgbjwwnjjcnkbw")
    public suspend fun rules(`value`: Output<List<CustomRuleArgs>>) {
        this.rules = value
    }

    @JvmName("nwuwglvyukcnctba")
    public suspend fun rules(vararg values: Output<CustomRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values List of rules
     */
    @JvmName("raokjyjidsnaflqv")
    public suspend fun rules(values: List<Output<CustomRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value List of rules
     */
    @JvmName("fthknghsnuielyso")
    public suspend fun rules(`value`: List<CustomRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument List of rules
     */
    @JvmName("brocvcbtgjoyufiw")
    public suspend fun rules(argument: List<suspend CustomRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CustomRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of rules
     */
    @JvmName("chrdxhgjubpgbxhf")
    public suspend fun rules(vararg argument: suspend CustomRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { CustomRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of rules
     */
    @JvmName("qbomuvubywkfyvfl")
    public suspend fun rules(argument: suspend CustomRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CustomRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values List of rules
     */
    @JvmName("jajscccrbpkwanqu")
    public suspend fun rules(vararg values: CustomRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): CustomRuleListArgs = CustomRuleListArgs(
        rules = rules,
    )
}
