@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestMethodConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the RequestMethod condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'RequestMethod'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleRequestMethodConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<RequestMethodMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestMethodConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestMethodConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestMethodConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleRequestMethodConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleRequestMethodConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<RequestMethodMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'RequestMethod'.
     */
    @JvmName("rspivqduhdlbrhei")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("gbxafkxirygjitsg")
    public suspend fun parameters(`value`: Output<RequestMethodMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'RequestMethod'.
     */
    @JvmName("vqnnlhoiynpakwqf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("dnuehexiwkvuopxo")
    public suspend fun parameters(`value`: RequestMethodMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("vvpuufeyepguyhwl")
    public suspend
    fun parameters(argument: suspend RequestMethodMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = RequestMethodMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleRequestMethodConditionArgs =
        DeliveryRuleRequestMethodConditionArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            parameters = parameters ?: throw PulumiNullFieldException("parameters"),
        )
}
