@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleServerPortConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the ServerPort condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'ServerPort'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleServerPortConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<ServerPortMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleServerPortConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleServerPortConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleServerPortConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleServerPortConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleServerPortConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<ServerPortMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'ServerPort'.
     */
    @JvmName("rmmpqqiytpfbwryy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("vjyitvivwidxeixu")
    public suspend fun parameters(`value`: Output<ServerPortMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'ServerPort'.
     */
    @JvmName("qbnbvpbcgplhkxyr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("mjsevcgusowwpiho")
    public suspend fun parameters(`value`: ServerPortMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("ruxuwxicscvmibyt")
    public suspend
    fun parameters(argument: suspend ServerPortMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = ServerPortMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleServerPortConditionArgs = DeliveryRuleServerPortConditionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
