@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleSocketAddrConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the SocketAddress condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'SocketAddr'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleSocketAddrConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<SocketAddrMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleSocketAddrConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleSocketAddrConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleSocketAddrConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleSocketAddrConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleSocketAddrConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<SocketAddrMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'SocketAddr'.
     */
    @JvmName("mvxhjsddwrdneuqv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("ctuxrlsmkcgrgyhw")
    public suspend fun parameters(`value`: Output<SocketAddrMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'SocketAddr'.
     */
    @JvmName("jbemkbnoffkuhmjw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("nnoexheoiqwvoopj")
    public suspend fun parameters(`value`: SocketAddrMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("qkotfxoypkdtmgqk")
    public suspend
    fun parameters(argument: suspend SocketAddrMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = SocketAddrMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleSocketAddrConditionArgs = DeliveryRuleSocketAddrConditionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
