@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.GeoFilterArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.GeoFilterActions
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rules defining user's geo access within a CDN endpoint.
 * @property action Action of the geo filter, i.e. allow or block access.
 * @property countryCodes Two letter country or region codes defining user country or region access in a geo filter, e.g. AU, MX, US.
 * @property relativePath Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
 */
public data class GeoFilterArgs(
    public val action: Output<GeoFilterActions>,
    public val countryCodes: Output<List<String>>,
    public val relativePath: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.GeoFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.GeoFilterArgs =
        com.pulumi.azurenative.cdn.inputs.GeoFilterArgs.builder()
            .action(action.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .countryCodes(countryCodes.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .relativePath(relativePath.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GeoFilterArgs].
 */
@PulumiTagMarker
public class GeoFilterArgsBuilder internal constructor() {
    private var action: Output<GeoFilterActions>? = null

    private var countryCodes: Output<List<String>>? = null

    private var relativePath: Output<String>? = null

    /**
     * @param value Action of the geo filter, i.e. allow or block access.
     */
    @JvmName("iwoeacfwkijxobdh")
    public suspend fun action(`value`: Output<GeoFilterActions>) {
        this.action = value
    }

    /**
     * @param value Two letter country or region codes defining user country or region access in a geo filter, e.g. AU, MX, US.
     */
    @JvmName("ofkbeascfpuimuds")
    public suspend fun countryCodes(`value`: Output<List<String>>) {
        this.countryCodes = value
    }

    @JvmName("llibbuxrqxpcljoe")
    public suspend fun countryCodes(vararg values: Output<String>) {
        this.countryCodes = Output.all(values.asList())
    }

    /**
     * @param values Two letter country or region codes defining user country or region access in a geo filter, e.g. AU, MX, US.
     */
    @JvmName("pwbpniiikylqhhns")
    public suspend fun countryCodes(values: List<Output<String>>) {
        this.countryCodes = Output.all(values)
    }

    /**
     * @param value Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
     */
    @JvmName("skkgwsaxnevompxe")
    public suspend fun relativePath(`value`: Output<String>) {
        this.relativePath = value
    }

    /**
     * @param value Action of the geo filter, i.e. allow or block access.
     */
    @JvmName("crbodxdjfhvidori")
    public suspend fun action(`value`: GeoFilterActions) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Two letter country or region codes defining user country or region access in a geo filter, e.g. AU, MX, US.
     */
    @JvmName("iixnovevdjohipwa")
    public suspend fun countryCodes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.countryCodes = mapped
    }

    /**
     * @param values Two letter country or region codes defining user country or region access in a geo filter, e.g. AU, MX, US.
     */
    @JvmName("phayjpctacabartk")
    public suspend fun countryCodes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.countryCodes = mapped
    }

    /**
     * @param value Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
     */
    @JvmName("hnkfmgvdcnqqqqan")
    public suspend fun relativePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relativePath = mapped
    }

    internal fun build(): GeoFilterArgs = GeoFilterArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        countryCodes = countryCodes ?: throw PulumiNullFieldException("countryCodes"),
        relativePath = relativePath ?: throw PulumiNullFieldException("relativePath"),
    )
}
