@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.GetProfileSupportedOptimizationTypesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium or CDN profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetProfileSupportedOptimizationTypesPlainArgs(
    public val profileName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.GetProfileSupportedOptimizationTypesPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.cdn.inputs.GetProfileSupportedOptimizationTypesPlainArgs =
        com.pulumi.azurenative.cdn.inputs.GetProfileSupportedOptimizationTypesPlainArgs.builder()
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProfileSupportedOptimizationTypesPlainArgs].
 */
@PulumiTagMarker
public class GetProfileSupportedOptimizationTypesPlainArgsBuilder internal constructor() {
    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium or CDN profile which is unique within the resource group.
     */
    @JvmName("lindoyvvimyxjtkp")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("ypnyksdpqgjqkwce")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetProfileSupportedOptimizationTypesPlainArgs =
        GetProfileSupportedOptimizationTypesPlainArgs(
            profileName = profileName ?: throw PulumiNullFieldException("profileName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
