@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.GetSecurityPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property securityPolicyName Name of the security policy under the profile.
 */
public data class GetSecurityPolicyPlainArgs(
    public val profileName: String,
    public val resourceGroupName: String,
    public val securityPolicyName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.GetSecurityPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.GetSecurityPolicyPlainArgs =
        com.pulumi.azurenative.cdn.inputs.GetSecurityPolicyPlainArgs.builder()
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .securityPolicyName(securityPolicyName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecurityPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetSecurityPolicyPlainArgsBuilder internal constructor() {
    private var profileName: String? = null

    private var resourceGroupName: String? = null

    private var securityPolicyName: String? = null

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("umdthritdhibvoaf")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("wawdsntqsmyflbro")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the security policy under the profile.
     */
    @JvmName("cknybrdubwiokuum")
    public suspend fun securityPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityPolicyName = mapped
    }

    internal fun build(): GetSecurityPolicyPlainArgs = GetSecurityPolicyPlainArgs(
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        securityPolicyName = securityPolicyName ?: throw PulumiNullFieldException("securityPolicyName"),
    )
}
