@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.HeaderActionParametersArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.HeaderAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the parameters for the request header action.
 * @property headerAction Action to perform
 * @property headerName Name of the header to modify
 * @property typeName
 * @property value Value for the specified action
 */
public data class HeaderActionParametersArgs(
    public val headerAction: Output<Either<String, HeaderAction>>,
    public val headerName: Output<String>,
    public val typeName: Output<String>,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.HeaderActionParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.HeaderActionParametersArgs =
        com.pulumi.azurenative.cdn.inputs.HeaderActionParametersArgs.builder()
            .headerAction(
                headerAction.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .headerName(headerName.applyValue({ args0 -> args0 }))
            .typeName(typeName.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HeaderActionParametersArgs].
 */
@PulumiTagMarker
public class HeaderActionParametersArgsBuilder internal constructor() {
    private var headerAction: Output<Either<String, HeaderAction>>? = null

    private var headerName: Output<String>? = null

    private var typeName: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Action to perform
     */
    @JvmName("qdgsextueoxgagjm")
    public suspend fun headerAction(`value`: Output<Either<String, HeaderAction>>) {
        this.headerAction = value
    }

    /**
     * @param value Name of the header to modify
     */
    @JvmName("helabmelsbvdglyy")
    public suspend fun headerName(`value`: Output<String>) {
        this.headerName = value
    }

    /**
     * @param value
     */
    @JvmName("brvambdwdkofgquu")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value Value for the specified action
     */
    @JvmName("hepwvwfjlhokdbbq")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Action to perform
     */
    @JvmName("glevtgdicaquextb")
    public suspend fun headerAction(`value`: Either<String, HeaderAction>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerAction = mapped
    }

    /**
     * @param value Action to perform
     */
    @JvmName("hbmpehklqslfdwmp")
    public fun headerAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HeaderAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerAction = mapped
    }

    /**
     * @param value Action to perform
     */
    @JvmName("nxsrvnyyfbylwxjm")
    public fun headerAction(`value`: HeaderAction) {
        val toBeMapped = Either.ofRight<String, HeaderAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerAction = mapped
    }

    /**
     * @param value Name of the header to modify
     */
    @JvmName("wbslvabsobdxhpjm")
    public suspend fun headerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerName = mapped
    }

    /**
     * @param value
     */
    @JvmName("kousonamygiouqlx")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    /**
     * @param value Value for the specified action
     */
    @JvmName("mwvcjrfhyaalglis")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): HeaderActionParametersArgs = HeaderActionParametersArgs(
        headerAction = headerAction ?: throw PulumiNullFieldException("headerAction"),
        headerName = headerName ?: throw PulumiNullFieldException("headerName"),
        typeName = typeName ?: throw PulumiNullFieldException("typeName"),
        `value` = `value`,
    )
}
