@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.HttpErrorRangeParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The JSON object that represents the range for http status codes
 * @property begin The inclusive start of the http status code range.
 * @property end The inclusive end of the http status code range.
 */
public data class HttpErrorRangeParametersArgs(
    public val begin: Output<Int>? = null,
    public val end: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.HttpErrorRangeParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.HttpErrorRangeParametersArgs =
        com.pulumi.azurenative.cdn.inputs.HttpErrorRangeParametersArgs.builder()
            .begin(begin?.applyValue({ args0 -> args0 }))
            .end(end?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpErrorRangeParametersArgs].
 */
@PulumiTagMarker
public class HttpErrorRangeParametersArgsBuilder internal constructor() {
    private var begin: Output<Int>? = null

    private var end: Output<Int>? = null

    /**
     * @param value The inclusive start of the http status code range.
     */
    @JvmName("lsbhhbpeiqhoyclr")
    public suspend fun begin(`value`: Output<Int>) {
        this.begin = value
    }

    /**
     * @param value The inclusive end of the http status code range.
     */
    @JvmName("nujkbpfaocvplupq")
    public suspend fun end(`value`: Output<Int>) {
        this.end = value
    }

    /**
     * @param value The inclusive start of the http status code range.
     */
    @JvmName("cepjdhniqgfjjggl")
    public suspend fun begin(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.begin = mapped
    }

    /**
     * @param value The inclusive end of the http status code range.
     */
    @JvmName("pkvyecuwuepgjqlg")
    public suspend fun end(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.end = mapped
    }

    internal fun build(): HttpErrorRangeParametersArgs = HttpErrorRangeParametersArgs(
        begin = begin,
        end = end,
    )
}
