@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.ManagedCertificateParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed Certificate used for https
 * @property type The type of the secret resource.
 * Expected value is 'ManagedCertificate'.
 */
public data class ManagedCertificateParametersArgs(
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.ManagedCertificateParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.ManagedCertificateParametersArgs =
        com.pulumi.azurenative.cdn.inputs.ManagedCertificateParametersArgs.builder()
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedCertificateParametersArgs].
 */
@PulumiTagMarker
public class ManagedCertificateParametersArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value The type of the secret resource.
     * Expected value is 'ManagedCertificate'.
     */
    @JvmName("gbjkouibdivkwjeb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The type of the secret resource.
     * Expected value is 'ManagedCertificate'.
     */
    @JvmName("dipabxedtffpqypq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ManagedCertificateParametersArgs = ManagedCertificateParametersArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
