@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.ManagedRuleSetListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the list of managed rule sets for the policy.
 * @property managedRuleSets List of rule sets.
 */
public data class ManagedRuleSetListArgs(
    public val managedRuleSets: Output<List<ManagedRuleSetArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.ManagedRuleSetListArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.ManagedRuleSetListArgs =
        com.pulumi.azurenative.cdn.inputs.ManagedRuleSetListArgs.builder()
            .managedRuleSets(
                managedRuleSets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedRuleSetListArgs].
 */
@PulumiTagMarker
public class ManagedRuleSetListArgsBuilder internal constructor() {
    private var managedRuleSets: Output<List<ManagedRuleSetArgs>>? = null

    /**
     * @param value List of rule sets.
     */
    @JvmName("nvpajulyoaoqfvyu")
    public suspend fun managedRuleSets(`value`: Output<List<ManagedRuleSetArgs>>) {
        this.managedRuleSets = value
    }

    @JvmName("rmxgjmnearggsrnl")
    public suspend fun managedRuleSets(vararg values: Output<ManagedRuleSetArgs>) {
        this.managedRuleSets = Output.all(values.asList())
    }

    /**
     * @param values List of rule sets.
     */
    @JvmName("xpdflisontgkiblh")
    public suspend fun managedRuleSets(values: List<Output<ManagedRuleSetArgs>>) {
        this.managedRuleSets = Output.all(values)
    }

    /**
     * @param value List of rule sets.
     */
    @JvmName("lmuetxcvucdluwqo")
    public suspend fun managedRuleSets(`value`: List<ManagedRuleSetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedRuleSets = mapped
    }

    /**
     * @param argument List of rule sets.
     */
    @JvmName("cxpqykvsiiplvycp")
    public suspend fun managedRuleSets(argument: List<suspend ManagedRuleSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedRuleSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedRuleSets = mapped
    }

    /**
     * @param argument List of rule sets.
     */
    @JvmName("lxxlkdskrqgxlmmk")
    public suspend fun managedRuleSets(
        vararg
        argument: suspend ManagedRuleSetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ManagedRuleSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedRuleSets = mapped
    }

    /**
     * @param argument List of rule sets.
     */
    @JvmName("woawdgwalgjimqwr")
    public suspend fun managedRuleSets(argument: suspend ManagedRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ManagedRuleSetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.managedRuleSets = mapped
    }

    /**
     * @param values List of rule sets.
     */
    @JvmName("gilxvcuhjplmrbii")
    public suspend fun managedRuleSets(vararg values: ManagedRuleSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedRuleSets = mapped
    }

    internal fun build(): ManagedRuleSetListArgs = ManagedRuleSetListArgs(
        managedRuleSets = managedRuleSets,
    )
}
