@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.RateLimitRuleArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.ActionType
import com.pulumi.azurenative.cdn.kotlin.enums.CustomRuleEnabledState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines a rate limiting rule that can be included in a waf policy
 * @property action Describes what action to be applied when rule matches
 * @property enabledState Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
 * @property matchConditions List of match conditions.
 * @property name Defines the name of the custom rule
 * @property priority Defines in what order this rule be evaluated in the overall list of custom rules
 * @property rateLimitDurationInMinutes Defines rate limit duration. Default is 1 minute.
 * @property rateLimitThreshold Defines rate limit threshold.
 */
public data class RateLimitRuleArgs(
    public val action: Output<Either<String, ActionType>>,
    public val enabledState: Output<Either<String, CustomRuleEnabledState>>? = null,
    public val matchConditions: Output<List<MatchConditionArgs>>,
    public val name: Output<String>,
    public val priority: Output<Int>,
    public val rateLimitDurationInMinutes: Output<Int>,
    public val rateLimitThreshold: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.RateLimitRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.RateLimitRuleArgs =
        com.pulumi.azurenative.cdn.inputs.RateLimitRuleArgs.builder()
            .action(
                action.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .matchConditions(
                matchConditions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .priority(priority.applyValue({ args0 -> args0 }))
            .rateLimitDurationInMinutes(rateLimitDurationInMinutes.applyValue({ args0 -> args0 }))
            .rateLimitThreshold(rateLimitThreshold.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RateLimitRuleArgs].
 */
@PulumiTagMarker
public class RateLimitRuleArgsBuilder internal constructor() {
    private var action: Output<Either<String, ActionType>>? = null

    private var enabledState: Output<Either<String, CustomRuleEnabledState>>? = null

    private var matchConditions: Output<List<MatchConditionArgs>>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var rateLimitDurationInMinutes: Output<Int>? = null

    private var rateLimitThreshold: Output<Int>? = null

    /**
     * @param value Describes what action to be applied when rule matches
     */
    @JvmName("ubnspejvkausuais")
    public suspend fun action(`value`: Output<Either<String, ActionType>>) {
        this.action = value
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("ijbbuujjfommdpdd")
    public suspend fun enabledState(`value`: Output<Either<String, CustomRuleEnabledState>>) {
        this.enabledState = value
    }

    /**
     * @param value List of match conditions.
     */
    @JvmName("biuddchgxtkuawgk")
    public suspend fun matchConditions(`value`: Output<List<MatchConditionArgs>>) {
        this.matchConditions = value
    }

    @JvmName("qcfpqjyrhtceiyyt")
    public suspend fun matchConditions(vararg values: Output<MatchConditionArgs>) {
        this.matchConditions = Output.all(values.asList())
    }

    /**
     * @param values List of match conditions.
     */
    @JvmName("hgphrnyognaxfipt")
    public suspend fun matchConditions(values: List<Output<MatchConditionArgs>>) {
        this.matchConditions = Output.all(values)
    }

    /**
     * @param value Defines the name of the custom rule
     */
    @JvmName("fopkofbgfldiskat")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines in what order this rule be evaluated in the overall list of custom rules
     */
    @JvmName("vihduvqmsmhsoggt")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Defines rate limit duration. Default is 1 minute.
     */
    @JvmName("kmvcyjjshgtvshfd")
    public suspend fun rateLimitDurationInMinutes(`value`: Output<Int>) {
        this.rateLimitDurationInMinutes = value
    }

    /**
     * @param value Defines rate limit threshold.
     */
    @JvmName("phinulmoapkktmtu")
    public suspend fun rateLimitThreshold(`value`: Output<Int>) {
        this.rateLimitThreshold = value
    }

    /**
     * @param value Describes what action to be applied when rule matches
     */
    @JvmName("ffbjaplmfxalftpo")
    public suspend fun action(`value`: Either<String, ActionType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes what action to be applied when rule matches
     */
    @JvmName("ekcuqylbnwmyenmj")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes what action to be applied when rule matches
     */
    @JvmName("hmdimgyrcthabebs")
    public fun action(`value`: ActionType) {
        val toBeMapped = Either.ofRight<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("mayqwrqknvvlngfb")
    public suspend fun enabledState(`value`: Either<String, CustomRuleEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("mtldmlbvktgulsxi")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CustomRuleEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("ojerjxrcmwgatbod")
    public fun enabledState(`value`: CustomRuleEnabledState) {
        val toBeMapped = Either.ofRight<String, CustomRuleEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value List of match conditions.
     */
    @JvmName("buniyfbpjthpuuei")
    public suspend fun matchConditions(`value`: List<MatchConditionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchConditions = mapped
    }

    /**
     * @param argument List of match conditions.
     */
    @JvmName("xweiwbqchvcepvvh")
    public suspend fun matchConditions(argument: List<suspend MatchConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MatchConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param argument List of match conditions.
     */
    @JvmName("qqkdvlyhodsrhugk")
    public suspend fun matchConditions(
        vararg
        argument: suspend MatchConditionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MatchConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param argument List of match conditions.
     */
    @JvmName("irelmablmolyruih")
    public suspend fun matchConditions(argument: suspend MatchConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MatchConditionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param values List of match conditions.
     */
    @JvmName("hoypggsbclxagqwu")
    public suspend fun matchConditions(vararg values: MatchConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchConditions = mapped
    }

    /**
     * @param value Defines the name of the custom rule
     */
    @JvmName("erdhbcvkqaamsjuw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines in what order this rule be evaluated in the overall list of custom rules
     */
    @JvmName("txdyjkgwgsoigggl")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Defines rate limit duration. Default is 1 minute.
     */
    @JvmName("dskfcibsrjtcyvan")
    public suspend fun rateLimitDurationInMinutes(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rateLimitDurationInMinutes = mapped
    }

    /**
     * @param value Defines rate limit threshold.
     */
    @JvmName("pjpaesllegdpytke")
    public suspend fun rateLimitThreshold(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rateLimitThreshold = mapped
    }

    internal fun build(): RateLimitRuleArgs = RateLimitRuleArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        enabledState = enabledState,
        matchConditions = matchConditions ?: throw PulumiNullFieldException("matchConditions"),
        name = name ?: throw PulumiNullFieldException("name"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
        rateLimitDurationInMinutes = rateLimitDurationInMinutes ?: throw
            PulumiNullFieldException("rateLimitDurationInMinutes"),
        rateLimitThreshold = rateLimitThreshold ?: throw PulumiNullFieldException("rateLimitThreshold"),
    )
}
