@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.RequestHeaderMatchConditionParametersArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.RequestHeaderOperator
import com.pulumi.azurenative.cdn.kotlin.enums.Transform
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the parameters for RequestHeader match conditions
 * @property matchValues The match value for the condition of the delivery rule
 * @property negateCondition Describes if this is negate condition or not
 * @property operator Describes operator to be matched
 * @property selector Name of Header to be matched
 * @property transforms List of transforms
 * @property typeName
 */
public data class RequestHeaderMatchConditionParametersArgs(
    public val matchValues: Output<List<String>>? = null,
    public val negateCondition: Output<Boolean>? = null,
    public val `operator`: Output<Either<String, RequestHeaderOperator>>,
    public val selector: Output<String>? = null,
    public val transforms: Output<List<Either<String, Transform>>>? = null,
    public val typeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.RequestHeaderMatchConditionParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.RequestHeaderMatchConditionParametersArgs =
        com.pulumi.azurenative.cdn.inputs.RequestHeaderMatchConditionParametersArgs.builder()
            .matchValues(matchValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .negateCondition(negateCondition?.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .selector(selector?.applyValue({ args0 -> args0 }))
            .transforms(
                transforms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .typeName(typeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RequestHeaderMatchConditionParametersArgs].
 */
@PulumiTagMarker
public class RequestHeaderMatchConditionParametersArgsBuilder internal constructor() {
    private var matchValues: Output<List<String>>? = null

    private var negateCondition: Output<Boolean>? = null

    private var `operator`: Output<Either<String, RequestHeaderOperator>>? = null

    private var selector: Output<String>? = null

    private var transforms: Output<List<Either<String, Transform>>>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value The match value for the condition of the delivery rule
     */
    @JvmName("wmpofovdendnonuc")
    public suspend fun matchValues(`value`: Output<List<String>>) {
        this.matchValues = value
    }

    @JvmName("rlbmpnuogxrxukly")
    public suspend fun matchValues(vararg values: Output<String>) {
        this.matchValues = Output.all(values.asList())
    }

    /**
     * @param values The match value for the condition of the delivery rule
     */
    @JvmName("iwqthacumtsvralr")
    public suspend fun matchValues(values: List<Output<String>>) {
        this.matchValues = Output.all(values)
    }

    /**
     * @param value Describes if this is negate condition or not
     */
    @JvmName("cqetxftmdjxyjvgu")
    public suspend fun negateCondition(`value`: Output<Boolean>) {
        this.negateCondition = value
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("qkitjekatrwevtes")
    public suspend fun `operator`(`value`: Output<Either<String, RequestHeaderOperator>>) {
        this.`operator` = value
    }

    /**
     * @param value Name of Header to be matched
     */
    @JvmName("qpdludmcqcjythac")
    public suspend fun selector(`value`: Output<String>) {
        this.selector = value
    }

    /**
     * @param value List of transforms
     */
    @JvmName("salbiqhbsoakrrqj")
    public suspend fun transforms(`value`: Output<List<Either<String, Transform>>>) {
        this.transforms = value
    }

    @JvmName("xirombslrkvidldj")
    public suspend fun transforms(vararg values: Output<Either<String, Transform>>) {
        this.transforms = Output.all(values.asList())
    }

    /**
     * @param values List of transforms
     */
    @JvmName("jebeijyhabjayvva")
    public suspend fun transforms(values: List<Output<Either<String, Transform>>>) {
        this.transforms = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("htayxxiqjqmnwdwn")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value The match value for the condition of the delivery rule
     */
    @JvmName("muhweelunoospkko")
    public suspend fun matchValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchValues = mapped
    }

    /**
     * @param values The match value for the condition of the delivery rule
     */
    @JvmName("hvsxdntxqrtfglks")
    public suspend fun matchValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchValues = mapped
    }

    /**
     * @param value Describes if this is negate condition or not
     */
    @JvmName("pnrusoeifjkfmnke")
    public suspend fun negateCondition(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negateCondition = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("pqymivpugqlunqyi")
    public suspend fun `operator`(`value`: Either<String, RequestHeaderOperator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("tclbjdndhqkulmtq")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RequestHeaderOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("rqeuskwwcbbfmvhs")
    public fun `operator`(`value`: RequestHeaderOperator) {
        val toBeMapped = Either.ofRight<String, RequestHeaderOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Name of Header to be matched
     */
    @JvmName("uqnannfbiettwbja")
    public suspend fun selector(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selector = mapped
    }

    /**
     * @param value List of transforms
     */
    @JvmName("nnmdrcdupglslyib")
    public suspend fun transforms(`value`: List<Either<String, Transform>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param values List of transforms
     */
    @JvmName("yoebybokbpxnsymw")
    public suspend fun transforms(vararg values: Either<String, Transform>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param value
     */
    @JvmName("wlwlyayitkwlatmj")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): RequestHeaderMatchConditionParametersArgs =
        RequestHeaderMatchConditionParametersArgs(
            matchValues = matchValues,
            negateCondition = negateCondition,
            `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
            selector = selector,
            transforms = transforms,
            typeName = typeName ?: throw PulumiNullFieldException("typeName"),
        )
}
