@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.UrlRedirectActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the url redirect action for the delivery rule.
 * @property name The name of the action for the delivery rule.
 * Expected value is 'UrlRedirect'.
 * @property parameters Defines the parameters for the action.
 */
public data class UrlRedirectActionArgs(
    public val name: Output<String>,
    public val parameters: Output<UrlRedirectActionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.UrlRedirectActionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.UrlRedirectActionArgs =
        com.pulumi.azurenative.cdn.inputs.UrlRedirectActionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [UrlRedirectActionArgs].
 */
@PulumiTagMarker
public class UrlRedirectActionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<UrlRedirectActionParametersArgs>? = null

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'UrlRedirect'.
     */
    @JvmName("pgnuqtrgkngjfsff")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("ucsecthiaqutwdfx")
    public suspend fun parameters(`value`: Output<UrlRedirectActionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'UrlRedirect'.
     */
    @JvmName("cgeyxhcerfgxvgrh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("ylgdgeucncjpdfdu")
    public suspend fun parameters(`value`: UrlRedirectActionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the action.
     */
    @JvmName("fvsupevpkbfpsndo")
    public suspend
    fun parameters(argument: suspend UrlRedirectActionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = UrlRedirectActionParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): UrlRedirectActionArgs = UrlRedirectActionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
