@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.UrlRewriteActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the url rewrite action for the delivery rule.
 * @property name The name of the action for the delivery rule.
 * Expected value is 'UrlRewrite'.
 * @property parameters Defines the parameters for the action.
 */
public data class UrlRewriteActionArgs(
    public val name: Output<String>,
    public val parameters: Output<UrlRewriteActionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.UrlRewriteActionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.UrlRewriteActionArgs =
        com.pulumi.azurenative.cdn.inputs.UrlRewriteActionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [UrlRewriteActionArgs].
 */
@PulumiTagMarker
public class UrlRewriteActionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<UrlRewriteActionParametersArgs>? = null

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'UrlRewrite'.
     */
    @JvmName("kijqwrfarumhoguj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("wqhuplqhtlmstrox")
    public suspend fun parameters(`value`: Output<UrlRewriteActionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'UrlRewrite'.
     */
    @JvmName("tnudncqrtxhpnxsv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("hjfiqqifqbqdvmot")
    public suspend fun parameters(`value`: UrlRewriteActionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the action.
     */
    @JvmName("ricgcogpgqfqbwdq")
    public suspend
    fun parameters(argument: suspend UrlRewriteActionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = UrlRewriteActionParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): UrlRewriteActionArgs = UrlRewriteActionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
