@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the parameters for using CDN managed certificate for securing custom domain.
 * @property certificateType Type of certificate used
 * @property typeName
 */
public data class CdnCertificateSourceParametersResponse(
    public val certificateType: String,
    public val typeName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.CdnCertificateSourceParametersResponse):
            CdnCertificateSourceParametersResponse = CdnCertificateSourceParametersResponse(
            certificateType = javaType.certificateType(),
            typeName = javaType.typeName(),
        )
    }
}
