@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the Cookies condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'Cookies'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleCookiesConditionResponse(
    public val name: String,
    public val parameters: CookiesMatchConditionParametersResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleCookiesConditionResponse):
            DeliveryRuleCookiesConditionResponse = DeliveryRuleCookiesConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.CookiesMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
