@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the IsDevice condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'IsDevice'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleIsDeviceConditionResponse(
    public val name: String,
    public val parameters: IsDeviceMatchConditionParametersResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleIsDeviceConditionResponse):
            DeliveryRuleIsDeviceConditionResponse = DeliveryRuleIsDeviceConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.IsDeviceMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
