@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the route configuration override action for the delivery rule. Only applicable to Frontdoor Standard/Premium Profiles.
 * @property name The name of the action for the delivery rule.
 * Expected value is 'RouteConfigurationOverride'.
 * @property parameters Defines the parameters for the action.
 */
public data class DeliveryRuleRouteConfigurationOverrideActionResponse(
    public val name: String,
    public val parameters: RouteConfigurationOverrideActionParametersResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleRouteConfigurationOverrideActionResponse):
            DeliveryRuleRouteConfigurationOverrideActionResponse =
            DeliveryRuleRouteConfigurationOverrideActionResponse(
                name = javaType.name(),
                parameters = javaType.parameters().let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.RouteConfigurationOverrideActionParametersResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
