@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the UrlPath condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'UrlPath'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleUrlPathConditionResponse(
    public val name: String,
    public val parameters: UrlPathMatchConditionParametersResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleUrlPathConditionResponse):
            DeliveryRuleUrlPathConditionResponse = DeliveryRuleUrlPathConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.UrlPathMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
