@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Defines contents of a web application firewall global configuration
 * @property defaultCustomBlockResponseBody If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
 * @property defaultCustomBlockResponseStatusCode If the action type is block, this field defines the default customer overridable http response status code.
 * @property defaultRedirectUrl If action type is redirect, this field represents the default redirect URL for the client.
 * @property enabledState describes if the policy is in enabled state or disabled state
 * @property mode Describes if it is in detection mode or prevention mode at policy level.
 */
public data class PolicySettingsResponse(
    public val defaultCustomBlockResponseBody: String? = null,
    public val defaultCustomBlockResponseStatusCode: Int? = null,
    public val defaultRedirectUrl: String? = null,
    public val enabledState: String? = null,
    public val mode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.PolicySettingsResponse):
            PolicySettingsResponse = PolicySettingsResponse(
            defaultCustomBlockResponseBody = javaType.defaultCustomBlockResponseBody().map({ args0 ->
                args0
            }).orElse(null),
            defaultCustomBlockResponseStatusCode = javaType.defaultCustomBlockResponseStatusCode().map({ args0 ->
                args0
            }).orElse(null),
            defaultRedirectUrl = javaType.defaultRedirectUrl().map({ args0 -> args0 }).orElse(null),
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
