@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the certificate source parameters using user's keyvault certificate for enabling SSL.
 * @property certificateSource Defines the source of the SSL certificate.
 * Expected value is 'AzureKeyVault'.
 * @property certificateSourceParameters Defines the certificate source parameters using user's keyvault certificate for enabling SSL.
 * @property minimumTlsVersion TLS protocol version that will be used for Https
 * @property protocolType Defines the TLS extension protocol that is used for secure delivery.
 */
public data class UserManagedHttpsParametersResponse(
    public val certificateSource: String,
    public val certificateSourceParameters: KeyVaultCertificateSourceParametersResponse,
    public val minimumTlsVersion: String? = null,
    public val protocolType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.UserManagedHttpsParametersResponse):
            UserManagedHttpsParametersResponse = UserManagedHttpsParametersResponse(
            certificateSource = javaType.certificateSource(),
            certificateSourceParameters = javaType.certificateSourceParameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.KeyVaultCertificateSourceParametersResponse.Companion.toKotlin(args0)
            }),
            minimumTlsVersion = javaType.minimumTlsVersion().map({ args0 -> args0 }).orElse(null),
            protocolType = javaType.protocolType(),
        )
    }
}
