@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.certificateregistration.kotlin

import com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderArgs.builder
import com.pulumi.azurenative.certificateregistration.kotlin.enums.CertificateProductType
import com.pulumi.azurenative.certificateregistration.kotlin.inputs.AppServiceCertificateArgs
import com.pulumi.azurenative.certificateregistration.kotlin.inputs.AppServiceCertificateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * SSL certificate purchase order.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Create Certificate order
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appServiceCertificateOrder = new AzureNative.CertificateRegistration.AppServiceCertificateOrder("appServiceCertificateOrder", new()
 *     {
 *         AutoRenew = true,
 *         CertificateOrderName = "SampleCertificateOrderName",
 *         Certificates =
 *         {
 *             { "SampleCertName1", new AzureNative.CertificateRegistration.Inputs.AppServiceCertificateArgs
 *             {
 *                 KeyVaultId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName",
 *                 KeyVaultSecretName = "SampleSecretName1",
 *             } },
 *             { "SampleCertName2", new AzureNative.CertificateRegistration.Inputs.AppServiceCertificateArgs
 *             {
 *                 KeyVaultId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName",
 *                 KeyVaultSecretName = "SampleSecretName2",
 *             } },
 *         },
 *         DistinguishedName = "CN=SampleCustomDomain.com",
 *         KeySize = 2048,
 *         Location = "Global",
 *         ProductType = AzureNative.CertificateRegistration.CertificateProductType.StandardDomainValidatedSsl,
 *         ResourceGroupName = "testrg123",
 *         ValidityInYears = 2,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/certificateregistration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := certificateregistration.NewAppServiceCertificateOrder(ctx, "appServiceCertificateOrder", &certificateregistration.AppServiceCertificateOrderArgs{
 * 			AutoRenew:            pulumi.Bool(true),
 * 			CertificateOrderName: pulumi.String("SampleCertificateOrderName"),
 * 			Certificates: certificateregistration.AppServiceCertificateMap{
 * 				"SampleCertName1": &certificateregistration.AppServiceCertificateArgs{
 * 					KeyVaultId:         pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
 * 					KeyVaultSecretName: pulumi.String("SampleSecretName1"),
 * 				},
 * 				"SampleCertName2": &certificateregistration.AppServiceCertificateArgs{
 * 					KeyVaultId:         pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
 * 					KeyVaultSecretName: pulumi.String("SampleSecretName2"),
 * 				},
 * 			},
 * 			DistinguishedName: pulumi.String("CN=SampleCustomDomain.com"),
 * 			KeySize:           pulumi.Int(2048),
 * 			Location:          pulumi.String("Global"),
 * 			ProductType:       certificateregistration.CertificateProductTypeStandardDomainValidatedSsl,
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			ValidityInYears:   pulumi.Int(2),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrder;
 * import com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appServiceCertificateOrder = new AppServiceCertificateOrder("appServiceCertificateOrder", AppServiceCertificateOrderArgs.builder()
 *             .autoRenew(true)
 *             .certificateOrderName("SampleCertificateOrderName")
 *             .certificates(Map.ofEntries(
 *                 Map.entry("SampleCertName1", Map.ofEntries(
 *                     Map.entry("keyVaultId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
 *                     Map.entry("keyVaultSecretName", "SampleSecretName1")
 *                 )),
 *                 Map.entry("SampleCertName2", Map.ofEntries(
 *                     Map.entry("keyVaultId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
 *                     Map.entry("keyVaultSecretName", "SampleSecretName2")
 *                 ))
 *             ))
 *             .distinguishedName("CN=SampleCustomDomain.com")
 *             .keySize(2048)
 *             .location("Global")
 *             .productType("StandardDomainValidatedSsl")
 *             .resourceGroupName("testrg123")
 *             .validityInYears(2)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:certificateregistration:AppServiceCertificateOrder SampleCertificateOrderName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}
 * ```
 * @property autoRenew <code>true</code> if the certificate should be automatically renewed when it expires; otherwise, <code>false</code>.
 * @property certificateOrderName Name of the certificate order.
 * @property certificates State of the Key Vault secret.
 * @property csr Last CSR that was created for this order.
 * @property distinguishedName Certificate distinguished name.
 * @property keySize Certificate key size.
 * @property kind Kind of resource.
 * @property location Resource Location.
 * @property productType Certificate product type.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property tags Resource tags.
 * @property validityInYears Duration in years (must be 1).
 */
public data class AppServiceCertificateOrderArgs(
    public val autoRenew: Output<Boolean>? = null,
    public val certificateOrderName: Output<String>? = null,
    public val certificates: Output<Map<String, AppServiceCertificateArgs>>? = null,
    public val csr: Output<String>? = null,
    public val distinguishedName: Output<String>? = null,
    public val keySize: Output<Int>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val productType: Output<CertificateProductType>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val validityInYears: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderArgs> {
    override fun toJava():
        com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderArgs =
        com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .certificateOrderName(certificateOrderName?.applyValue({ args0 -> args0 }))
            .certificates(
                certificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .csr(csr?.applyValue({ args0 -> args0 }))
            .distinguishedName(distinguishedName?.applyValue({ args0 -> args0 }))
            .keySize(keySize?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .productType(productType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .validityInYears(validityInYears?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppServiceCertificateOrderArgs].
 */
@PulumiTagMarker
public class AppServiceCertificateOrderArgsBuilder internal constructor() {
    private var autoRenew: Output<Boolean>? = null

    private var certificateOrderName: Output<String>? = null

    private var certificates: Output<Map<String, AppServiceCertificateArgs>>? = null

    private var csr: Output<String>? = null

    private var distinguishedName: Output<String>? = null

    private var keySize: Output<Int>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var productType: Output<CertificateProductType>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var validityInYears: Output<Int>? = null

    /**
     * @param value <code>true</code> if the certificate should be automatically renewed when it expires; otherwise, <code>false</code>.
     */
    @JvmName("fhgulilpelvwwbyh")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value Name of the certificate order.
     */
    @JvmName("awewqwcxhbtoqfgd")
    public suspend fun certificateOrderName(`value`: Output<String>) {
        this.certificateOrderName = value
    }

    /**
     * @param value State of the Key Vault secret.
     */
    @JvmName("sabtoochxustxqvo")
    public suspend fun certificates(`value`: Output<Map<String, AppServiceCertificateArgs>>) {
        this.certificates = value
    }

    /**
     * @param value Last CSR that was created for this order.
     */
    @JvmName("coeqjgwqpgfjadmb")
    public suspend fun csr(`value`: Output<String>) {
        this.csr = value
    }

    /**
     * @param value Certificate distinguished name.
     */
    @JvmName("nkvgiaeorwkueucp")
    public suspend fun distinguishedName(`value`: Output<String>) {
        this.distinguishedName = value
    }

    /**
     * @param value Certificate key size.
     */
    @JvmName("ofgsteywndccbihr")
    public suspend fun keySize(`value`: Output<Int>) {
        this.keySize = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("ypwhxqoeelebcvrh")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("cmbqaowbmdurolav")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Certificate product type.
     */
    @JvmName("jwqbjkkqfgcuvndn")
    public suspend fun productType(`value`: Output<CertificateProductType>) {
        this.productType = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("beoowbwdoekjnrcd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dnnxtgbkolurekdb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Duration in years (must be 1).
     */
    @JvmName("cwwdvxlpixsrtrkd")
    public suspend fun validityInYears(`value`: Output<Int>) {
        this.validityInYears = value
    }

    /**
     * @param value <code>true</code> if the certificate should be automatically renewed when it expires; otherwise, <code>false</code>.
     */
    @JvmName("vpotveyvtorvnjjn")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Name of the certificate order.
     */
    @JvmName("srgilnspgbpbcwyu")
    public suspend fun certificateOrderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateOrderName = mapped
    }

    /**
     * @param value State of the Key Vault secret.
     */
    @JvmName("jpnoatgftvljquas")
    public suspend fun certificates(`value`: Map<String, AppServiceCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param argument State of the Key Vault secret.
     */
    @JvmName("wfebakgiekaldbxf")
    public suspend fun certificates(
        vararg
        argument: Pair<String, suspend AppServiceCertificateArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                AppServiceCertificateArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param values State of the Key Vault secret.
     */
    @JvmName("lwrutxorltecqkrb")
    public fun certificates(vararg values: Pair<String, AppServiceCertificateArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param value Last CSR that was created for this order.
     */
    @JvmName("wxixggnhpvcvfpwh")
    public suspend fun csr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csr = mapped
    }

    /**
     * @param value Certificate distinguished name.
     */
    @JvmName("qlgmbuudryeskuuq")
    public suspend fun distinguishedName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distinguishedName = mapped
    }

    /**
     * @param value Certificate key size.
     */
    @JvmName("mibaktavybifsnje")
    public suspend fun keySize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keySize = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("yghrcvgmiewqrhyl")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("ahnxndrmtewxefxx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Certificate product type.
     */
    @JvmName("eqyldsmnfxayecsr")
    public suspend fun productType(`value`: CertificateProductType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productType = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("uekskydfrgywcaql")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iomqcdykrcvjfaam")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("idkvkgdytyitxmfy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Duration in years (must be 1).
     */
    @JvmName("flycudwgjgjxjspt")
    public suspend fun validityInYears(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validityInYears = mapped
    }

    internal fun build(): AppServiceCertificateOrderArgs = AppServiceCertificateOrderArgs(
        autoRenew = autoRenew,
        certificateOrderName = certificateOrderName,
        certificates = certificates,
        csr = csr,
        distinguishedName = distinguishedName,
        keySize = keySize,
        kind = kind,
        location = location,
        productType = productType,
        resourceGroupName = resourceGroupName,
        tags = tags,
        validityInYears = validityInYears,
    )
}
