@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.certificateregistration.kotlin

import com.pulumi.azurenative.certificateregistration.CertificateregistrationFunctions.getAppServiceCertificateOrderCertificatePlain
import com.pulumi.azurenative.certificateregistration.CertificateregistrationFunctions.getAppServiceCertificateOrderPlain
import com.pulumi.azurenative.certificateregistration.kotlin.inputs.GetAppServiceCertificateOrderCertificatePlainArgs
import com.pulumi.azurenative.certificateregistration.kotlin.inputs.GetAppServiceCertificateOrderCertificatePlainArgsBuilder
import com.pulumi.azurenative.certificateregistration.kotlin.inputs.GetAppServiceCertificateOrderPlainArgs
import com.pulumi.azurenative.certificateregistration.kotlin.inputs.GetAppServiceCertificateOrderPlainArgsBuilder
import com.pulumi.azurenative.certificateregistration.kotlin.outputs.GetAppServiceCertificateOrderCertificateResult
import com.pulumi.azurenative.certificateregistration.kotlin.outputs.GetAppServiceCertificateOrderResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.certificateregistration.kotlin.outputs.GetAppServiceCertificateOrderCertificateResult.Companion.toKotlin as getAppServiceCertificateOrderCertificateResultToKotlin
import com.pulumi.azurenative.certificateregistration.kotlin.outputs.GetAppServiceCertificateOrderResult.Companion.toKotlin as getAppServiceCertificateOrderResultToKotlin

public object CertificateregistrationFunctions {
    /**
     * Description for Get a certificate order.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2020-10-01, 2023-01-01.
     * @param argument null
     * @return SSL certificate purchase order.
     */
    public suspend
    fun getAppServiceCertificateOrder(argument: GetAppServiceCertificateOrderPlainArgs):
        GetAppServiceCertificateOrderResult =
        getAppServiceCertificateOrderResultToKotlin(getAppServiceCertificateOrderPlain(argument.toJava()).await())

    /**
     * @see [getAppServiceCertificateOrder].
     * @param certificateOrderName Name of the certificate order..
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @return SSL certificate purchase order.
     */
    public suspend fun getAppServiceCertificateOrder(
        certificateOrderName: String,
        resourceGroupName: String,
    ): GetAppServiceCertificateOrderResult {
        val argument = GetAppServiceCertificateOrderPlainArgs(
            certificateOrderName = certificateOrderName,
            resourceGroupName = resourceGroupName,
        )
        return getAppServiceCertificateOrderResultToKotlin(getAppServiceCertificateOrderPlain(argument.toJava()).await())
    }

    /**
     * @see [getAppServiceCertificateOrder].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;certificateregistration&#46;kotlin&#46;inputs&#46;GetAppServiceCertificateOrderPlainArgs].
     * @return SSL certificate purchase order.
     */
    public suspend
    fun getAppServiceCertificateOrder(argument: suspend GetAppServiceCertificateOrderPlainArgsBuilder.() -> Unit):
        GetAppServiceCertificateOrderResult {
        val builder = GetAppServiceCertificateOrderPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAppServiceCertificateOrderResultToKotlin(getAppServiceCertificateOrderPlain(builtArgument.toJava()).await())
    }

    /**
     * Description for Get the certificate associated with a certificate order.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2020-10-01, 2023-01-01.
     * @param argument null
     * @return Key Vault container ARM resource for a certificate that is purchased through Azure.
     */
    public suspend
    fun getAppServiceCertificateOrderCertificate(argument: GetAppServiceCertificateOrderCertificatePlainArgs):
        GetAppServiceCertificateOrderCertificateResult =
        getAppServiceCertificateOrderCertificateResultToKotlin(getAppServiceCertificateOrderCertificatePlain(argument.toJava()).await())

    /**
     * @see [getAppServiceCertificateOrderCertificate].
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @return Key Vault container ARM resource for a certificate that is purchased through Azure.
     */
    public suspend fun getAppServiceCertificateOrderCertificate(
        certificateOrderName: String,
        name: String,
        resourceGroupName: String,
    ): GetAppServiceCertificateOrderCertificateResult {
        val argument = GetAppServiceCertificateOrderCertificatePlainArgs(
            certificateOrderName = certificateOrderName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getAppServiceCertificateOrderCertificateResultToKotlin(getAppServiceCertificateOrderCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getAppServiceCertificateOrderCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;certificateregistration&#46;kotlin&#46;inputs&#46;GetAppServiceCertificateOrderCertificatePlainArgs].
     * @return Key Vault container ARM resource for a certificate that is purchased through Azure.
     */
    public suspend
    fun getAppServiceCertificateOrderCertificate(argument: suspend GetAppServiceCertificateOrderCertificatePlainArgsBuilder.() -> Unit):
        GetAppServiceCertificateOrderCertificateResult {
        val builder = GetAppServiceCertificateOrderCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAppServiceCertificateOrderCertificateResultToKotlin(getAppServiceCertificateOrderCertificatePlain(builtArgument.toJava()).await())
    }
}
