@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.certificateregistration.kotlin.inputs

import com.pulumi.azurenative.certificateregistration.inputs.GetAppServiceCertificateOrderCertificatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateOrderName Name of the certificate order.
 * @property name Name of the certificate.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetAppServiceCertificateOrderCertificatePlainArgs(
    public val certificateOrderName: String,
    public val name: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.certificateregistration.inputs.GetAppServiceCertificateOrderCertificatePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.certificateregistration.inputs.GetAppServiceCertificateOrderCertificatePlainArgs =
        com.pulumi.azurenative.certificateregistration.inputs.GetAppServiceCertificateOrderCertificatePlainArgs.builder()
            .certificateOrderName(certificateOrderName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAppServiceCertificateOrderCertificatePlainArgs].
 */
@PulumiTagMarker
public class GetAppServiceCertificateOrderCertificatePlainArgsBuilder internal constructor() {
    private var certificateOrderName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the certificate order.
     */
    @JvmName("pigmvqrkwbaeisck")
    public suspend fun certificateOrderName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.certificateOrderName = mapped
    }

    /**
     * @param value Name of the certificate.
     */
    @JvmName("nrjkxtypssfmvoja")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("yxdjtsmpcdhyykxy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAppServiceCertificateOrderCertificatePlainArgs =
        GetAppServiceCertificateOrderCertificatePlainArgs(
            certificateOrderName = certificateOrderName ?: throw
                PulumiNullFieldException("certificateOrderName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
