@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.certificateregistration.kotlin.inputs

import com.pulumi.azurenative.certificateregistration.inputs.GetAppServiceCertificateOrderPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateOrderName Name of the certificate order..
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetAppServiceCertificateOrderPlainArgs(
    public val certificateOrderName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.certificateregistration.inputs.GetAppServiceCertificateOrderPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.certificateregistration.inputs.GetAppServiceCertificateOrderPlainArgs =
        com.pulumi.azurenative.certificateregistration.inputs.GetAppServiceCertificateOrderPlainArgs.builder()
            .certificateOrderName(certificateOrderName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAppServiceCertificateOrderPlainArgs].
 */
@PulumiTagMarker
public class GetAppServiceCertificateOrderPlainArgsBuilder internal constructor() {
    private var certificateOrderName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the certificate order..
     */
    @JvmName("yelvlcfjvegkvgse")
    public suspend fun certificateOrderName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.certificateOrderName = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("yqdcnflvxnhvmxwf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAppServiceCertificateOrderPlainArgs =
        GetAppServiceCertificateOrderPlainArgs(
            certificateOrderName = certificateOrderName ?: throw
                PulumiNullFieldException("certificateOrderName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
