@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.changeanalysis.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
 */
public enum class ManagedIdentityTypes(
    public val javaValue: com.pulumi.azurenative.changeanalysis.enums.ManagedIdentityTypes,
) : ConvertibleToJava<com.pulumi.azurenative.changeanalysis.enums.ManagedIdentityTypes> {
    None(com.pulumi.azurenative.changeanalysis.enums.ManagedIdentityTypes.None),
    SystemAssigned(com.pulumi.azurenative.changeanalysis.enums.ManagedIdentityTypes.SystemAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.changeanalysis.enums.ManagedIdentityTypes =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.changeanalysis.enums.ManagedIdentityTypes):
            ManagedIdentityTypes = ManagedIdentityTypes.values().first { it.javaValue == javaType }
    }
}
