@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.changeanalysis.kotlin.inputs

import com.pulumi.azurenative.changeanalysis.inputs.ConfigurationProfileResourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of a configuration profile.
 * @property notifications Settings of change notification configuration for a subscription.
 */
public data class ConfigurationProfileResourcePropertiesArgs(
    public val notifications: Output<NotificationSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.changeanalysis.inputs.ConfigurationProfileResourcePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.changeanalysis.inputs.ConfigurationProfileResourcePropertiesArgs =
        com.pulumi.azurenative.changeanalysis.inputs.ConfigurationProfileResourcePropertiesArgs.builder()
            .notifications(notifications?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConfigurationProfileResourcePropertiesArgs].
 */
@PulumiTagMarker
public class ConfigurationProfileResourcePropertiesArgsBuilder internal constructor() {
    private var notifications: Output<NotificationSettingsArgs>? = null

    /**
     * @param value Settings of change notification configuration for a subscription.
     */
    @JvmName("kevnfvgqwckpbxah")
    public suspend fun notifications(`value`: Output<NotificationSettingsArgs>) {
        this.notifications = value
    }

    /**
     * @param value Settings of change notification configuration for a subscription.
     */
    @JvmName("cyfaufwlntycbglu")
    public suspend fun notifications(`value`: NotificationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifications = mapped
    }

    /**
     * @param argument Settings of change notification configuration for a subscription.
     */
    @JvmName("kqpuchpjbflscmpc")
    public suspend fun notifications(argument: suspend NotificationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = NotificationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.notifications = mapped
    }

    internal fun build(): ConfigurationProfileResourcePropertiesArgs =
        ConfigurationProfileResourcePropertiesArgs(
            notifications = notifications,
        )
}
