@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin

import com.pulumi.azurenative.chaos.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.chaos.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Target].
 */
@PulumiTagMarker
public class TargetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TargetArgs = TargetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TargetArgsBuilder.() -> Unit) {
        val builder = TargetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Target {
        val builtJavaResource = com.pulumi.azurenative.chaos.Target(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Target(builtJavaResource)
    }
}

/**
 * Model that represents a Target resource.
 * Azure REST API version: 2023-04-15-preview. Prior API version in Azure Native 1.x: 2021-09-15-preview.
 * Other available API versions: 2023-09-01-preview, 2023-10-27-preview, 2023-11-01, 2024-01-01.
 * ## Example Usage
 * ### Create/update a Target that extends a virtual machine resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var target = new AzureNative.Chaos.Target("target", new()
 *     {
 *         ParentProviderNamespace = "Microsoft.Compute",
 *         ParentResourceName = "exampleVM",
 *         ParentResourceType = "virtualMachines",
 *         Properties =
 *         {
 *             { "identities", new[]
 *             {
 *                 {
 *                     { "subject", "CN=example.subject" },
 *                     { "type", "CertificateSubjectIssuer" },
 *                 },
 *             } },
 *         },
 *         ResourceGroupName = "exampleRG",
 *         TargetName = "Microsoft-Agent",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/chaos/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chaos.NewTarget(ctx, "target", &chaos.TargetArgs{
 * 			ParentProviderNamespace: pulumi.String("Microsoft.Compute"),
 * 			ParentResourceName:      pulumi.String("exampleVM"),
 * 			ParentResourceType:      pulumi.String("virtualMachines"),
 * 			Properties: pulumi.Any{
 * 				Identities: []map[string]interface{}{
 * 					map[string]interface{}{
 * 						"subject": "CN=example.subject",
 * 						"type":    "CertificateSubjectIssuer",
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleRG"),
 * 			TargetName:        pulumi.String("Microsoft-Agent"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.chaos.Target;
 * import com.pulumi.azurenative.chaos.TargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var target = new Target("target", TargetArgs.builder()
 *             .parentProviderNamespace("Microsoft.Compute")
 *             .parentResourceName("exampleVM")
 *             .parentResourceType("virtualMachines")
 *             .properties(Map.of("identities", Map.ofEntries(
 *                 Map.entry("subject", "CN=example.subject"),
 *                 Map.entry("type", "CertificateSubjectIssuer")
 *             )))
 *             .resourceGroupName("exampleRG")
 *             .targetName("Microsoft-Agent")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:chaos:Target Microsoft-Agent /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}
 * ```
 */
public class Target internal constructor(
    override val javaResource: com.pulumi.azurenative.chaos.Target,
) : KotlinCustomResource(javaResource, TargetMapper) {
    /**
     * Location of the target resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The properties of the target resource.
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * The system metadata of the target resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TargetMapper : ResourceMapper<Target> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.chaos.Target::class == javaResource::class

    override fun map(javaResource: Resource): Target = Target(
        javaResource as
            com.pulumi.azurenative.chaos.Target,
    )
}

/**
 * @see [Target].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Target].
 */
public suspend fun target(name: String, block: suspend TargetResourceBuilder.() -> Unit): Target {
    val builder = TargetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Target].
 * @param name The _unique_ name of the resulting resource.
 */
public fun target(name: String): Target {
    val builder = TargetResourceBuilder()
    builder.name(name)
    return builder.build()
}
