@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.ContinuousActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Model that represents a continuous action.
 * @property duration ISO8601 formatted string that represents a duration.
 * @property name String that represents a Capability URN.
 * @property parameters List of key value pairs.
 * @property selectorId String that represents a selector.
 * @property type Enum that discriminates between action models.
 * Expected value is 'continuous'.
 */
public data class ContinuousActionArgs(
    public val duration: Output<String>,
    public val name: Output<String>,
    public val parameters: Output<List<KeyValuePairArgs>>,
    public val selectorId: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.ContinuousActionArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.ContinuousActionArgs =
        com.pulumi.azurenative.chaos.inputs.ContinuousActionArgs.builder()
            .duration(duration.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(
                parameters.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .selectorId(selectorId.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContinuousActionArgs].
 */
@PulumiTagMarker
public class ContinuousActionArgsBuilder internal constructor() {
    private var duration: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<List<KeyValuePairArgs>>? = null

    private var selectorId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value ISO8601 formatted string that represents a duration.
     */
    @JvmName("deogsvbmwhrkeidw")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value String that represents a Capability URN.
     */
    @JvmName("qbihkfodnmoumgii")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of key value pairs.
     */
    @JvmName("hlykwcqfffyqvnhk")
    public suspend fun parameters(`value`: Output<List<KeyValuePairArgs>>) {
        this.parameters = value
    }

    @JvmName("ubrxnorecickjxki")
    public suspend fun parameters(vararg values: Output<KeyValuePairArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values List of key value pairs.
     */
    @JvmName("rjtxplnxofatysay")
    public suspend fun parameters(values: List<Output<KeyValuePairArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value String that represents a selector.
     */
    @JvmName("bvhqoqtfvdmmxiex")
    public suspend fun selectorId(`value`: Output<String>) {
        this.selectorId = value
    }

    /**
     * @param value Enum that discriminates between action models.
     * Expected value is 'continuous'.
     */
    @JvmName("akxxibsfcjfdnlow")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value ISO8601 formatted string that represents a duration.
     */
    @JvmName("dbmyxjryheorruom")
    public suspend fun duration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value String that represents a Capability URN.
     */
    @JvmName("xcuuoqdthwifyhmg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of key value pairs.
     */
    @JvmName("nrsfmxisysgftptb")
    public suspend fun parameters(`value`: List<KeyValuePairArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument List of key value pairs.
     */
    @JvmName("yijiksntshglvtbf")
    public suspend fun parameters(argument: List<suspend KeyValuePairArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KeyValuePairArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument List of key value pairs.
     */
    @JvmName("yctuhqihprylmpga")
    public suspend fun parameters(vararg argument: suspend KeyValuePairArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KeyValuePairArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument List of key value pairs.
     */
    @JvmName("dkqasxokfqroprvi")
    public suspend fun parameters(argument: suspend KeyValuePairArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KeyValuePairArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values List of key value pairs.
     */
    @JvmName("stocdasvmkyisbsh")
    public suspend fun parameters(vararg values: KeyValuePairArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value String that represents a selector.
     */
    @JvmName("wbyjxvgxsvdpyquv")
    public suspend fun selectorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectorId = mapped
    }

    /**
     * @param value Enum that discriminates between action models.
     * Expected value is 'continuous'.
     */
    @JvmName("wvymttolvwienrrb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ContinuousActionArgs = ContinuousActionArgs(
        duration = duration ?: throw PulumiNullFieldException("duration"),
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
        selectorId = selectorId ?: throw PulumiNullFieldException("selectorId"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
