@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.ExperimentPropertiesArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Model that represents the Experiment properties model.
 * @property selectors List of selectors.
 * @property startOnCreation A boolean value that indicates if experiment should be started on creation or not.
 * @property steps List of steps.
 */
public data class ExperimentPropertiesArgs(
    public val selectors: Output<List<Either<ListSelectorArgs, QuerySelectorArgs>>>,
    public val startOnCreation: Output<Boolean>? = null,
    public val steps: Output<List<StepArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.ExperimentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.ExperimentPropertiesArgs =
        com.pulumi.azurenative.chaos.inputs.ExperimentPropertiesArgs.builder()
            .selectors(
                selectors.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .startOnCreation(startOnCreation?.applyValue({ args0 -> args0 }))
            .steps(
                steps.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExperimentPropertiesArgs].
 */
@PulumiTagMarker
public class ExperimentPropertiesArgsBuilder internal constructor() {
    private var selectors: Output<List<Either<ListSelectorArgs, QuerySelectorArgs>>>? = null

    private var startOnCreation: Output<Boolean>? = null

    private var steps: Output<List<StepArgs>>? = null

    /**
     * @param value List of selectors.
     */
    @JvmName("fatyqwtxkttvuvnb")
    public suspend fun selectors(`value`: Output<List<Either<ListSelectorArgs, QuerySelectorArgs>>>) {
        this.selectors = value
    }

    @JvmName("nvbvlhoheqnxbmiy")
    public suspend fun selectors(vararg values: Output<Either<ListSelectorArgs, QuerySelectorArgs>>) {
        this.selectors = Output.all(values.asList())
    }

    /**
     * @param values List of selectors.
     */
    @JvmName("qtunfcwmstfyehyv")
    public suspend fun selectors(values: List<Output<Either<ListSelectorArgs, QuerySelectorArgs>>>) {
        this.selectors = Output.all(values)
    }

    /**
     * @param value A boolean value that indicates if experiment should be started on creation or not.
     */
    @JvmName("wimcrqqjligfwvct")
    public suspend fun startOnCreation(`value`: Output<Boolean>) {
        this.startOnCreation = value
    }

    /**
     * @param value List of steps.
     */
    @JvmName("nqtltlpxuaxtuyyj")
    public suspend fun steps(`value`: Output<List<StepArgs>>) {
        this.steps = value
    }

    @JvmName("yajorqqorkcfwsvd")
    public suspend fun steps(vararg values: Output<StepArgs>) {
        this.steps = Output.all(values.asList())
    }

    /**
     * @param values List of steps.
     */
    @JvmName("fcnuctaxfkpbkint")
    public suspend fun steps(values: List<Output<StepArgs>>) {
        this.steps = Output.all(values)
    }

    /**
     * @param value List of selectors.
     */
    @JvmName("bpcdjxulrkhkafpj")
    public suspend fun selectors(`value`: List<Either<ListSelectorArgs, QuerySelectorArgs>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectors = mapped
    }

    /**
     * @param values List of selectors.
     */
    @JvmName("xaxvoqkwuoijkmve")
    public suspend fun selectors(vararg values: Either<ListSelectorArgs, QuerySelectorArgs>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectors = mapped
    }

    /**
     * @param value A boolean value that indicates if experiment should be started on creation or not.
     */
    @JvmName("ofqefqyfckkvvdft")
    public suspend fun startOnCreation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startOnCreation = mapped
    }

    /**
     * @param value List of steps.
     */
    @JvmName("lronveaiwejwqfcs")
    public suspend fun steps(`value`: List<StepArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.steps = mapped
    }

    /**
     * @param argument List of steps.
     */
    @JvmName("bcvngqlnnaovxphd")
    public suspend fun steps(argument: List<suspend StepArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { StepArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param argument List of steps.
     */
    @JvmName("aycipjdgyibrkavx")
    public suspend fun steps(vararg argument: suspend StepArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { StepArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param argument List of steps.
     */
    @JvmName("unpmlpioyaeciibv")
    public suspend fun steps(argument: suspend StepArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StepArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param values List of steps.
     */
    @JvmName("qsbupdjioprgmaoh")
    public suspend fun steps(vararg values: StepArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.steps = mapped
    }

    internal fun build(): ExperimentPropertiesArgs = ExperimentPropertiesArgs(
        selectors = selectors ?: throw PulumiNullFieldException("selectors"),
        startOnCreation = startOnCreation,
        steps = steps ?: throw PulumiNullFieldException("steps"),
    )
}
