@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.GetExperimentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property experimentName String that represents a Experiment resource name.
 * @property resourceGroupName String that represents an Azure resource group.
 */
public data class GetExperimentPlainArgs(
    public val experimentName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.GetExperimentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.GetExperimentPlainArgs =
        com.pulumi.azurenative.chaos.inputs.GetExperimentPlainArgs.builder()
            .experimentName(experimentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExperimentPlainArgs].
 */
@PulumiTagMarker
public class GetExperimentPlainArgsBuilder internal constructor() {
    private var experimentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value String that represents a Experiment resource name.
     */
    @JvmName("uuijtygutmghfako")
    public suspend fun experimentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.experimentName = mapped
    }

    /**
     * @param value String that represents an Azure resource group.
     */
    @JvmName("vcwqemrnacftpvna")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExperimentPlainArgs = GetExperimentPlainArgs(
        experimentName = experimentName ?: throw PulumiNullFieldException("experimentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
