@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.QuerySelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Model that represents a query selector.
 * @property filter Model that represents available filter types that can be applied to a targets list.
 * @property id String of the selector ID.
 * @property queryString Azure Resource Graph (ARG) Query Language query for target resources.
 * @property subscriptionIds Subscription id list to scope resource query.
 * @property type Enum of the selector type.
 * Expected value is 'Query'.
 */
public data class QuerySelectorArgs(
    public val filter: Output<SimpleFilterArgs>? = null,
    public val id: Output<String>,
    public val queryString: Output<String>,
    public val subscriptionIds: Output<List<String>>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.QuerySelectorArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.QuerySelectorArgs =
        com.pulumi.azurenative.chaos.inputs.QuerySelectorArgs.builder()
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id.applyValue({ args0 -> args0 }))
            .queryString(queryString.applyValue({ args0 -> args0 }))
            .subscriptionIds(subscriptionIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QuerySelectorArgs].
 */
@PulumiTagMarker
public class QuerySelectorArgsBuilder internal constructor() {
    private var filter: Output<SimpleFilterArgs>? = null

    private var id: Output<String>? = null

    private var queryString: Output<String>? = null

    private var subscriptionIds: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Model that represents available filter types that can be applied to a targets list.
     */
    @JvmName("hpsaihnmrsmcqiev")
    public suspend fun filter(`value`: Output<SimpleFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value String of the selector ID.
     */
    @JvmName("lleshwfyrcpwixup")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Azure Resource Graph (ARG) Query Language query for target resources.
     */
    @JvmName("ppljlhfkknojiyms")
    public suspend fun queryString(`value`: Output<String>) {
        this.queryString = value
    }

    /**
     * @param value Subscription id list to scope resource query.
     */
    @JvmName("ncnpoxleeejlnqwg")
    public suspend fun subscriptionIds(`value`: Output<List<String>>) {
        this.subscriptionIds = value
    }

    @JvmName("xjqpawkqhfkfunpe")
    public suspend fun subscriptionIds(vararg values: Output<String>) {
        this.subscriptionIds = Output.all(values.asList())
    }

    /**
     * @param values Subscription id list to scope resource query.
     */
    @JvmName("okskkkkwlwwtoyya")
    public suspend fun subscriptionIds(values: List<Output<String>>) {
        this.subscriptionIds = Output.all(values)
    }

    /**
     * @param value Enum of the selector type.
     * Expected value is 'Query'.
     */
    @JvmName("csvbxveldqbsmvkq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Model that represents available filter types that can be applied to a targets list.
     */
    @JvmName("pxfplsjkvkawncsm")
    public suspend fun filter(`value`: SimpleFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Model that represents available filter types that can be applied to a targets list.
     */
    @JvmName("dqrluibdrmcjwkhr")
    public suspend fun filter(argument: suspend SimpleFilterArgsBuilder.() -> Unit) {
        val toBeMapped = SimpleFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value String of the selector ID.
     */
    @JvmName("psbtcuaxaxndvhje")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Azure Resource Graph (ARG) Query Language query for target resources.
     */
    @JvmName("wrooblyknhhtjmmr")
    public suspend fun queryString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param value Subscription id list to scope resource query.
     */
    @JvmName("gdyinshypnruepix")
    public suspend fun subscriptionIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptionIds = mapped
    }

    /**
     * @param values Subscription id list to scope resource query.
     */
    @JvmName("otefcrdudfrjruel")
    public suspend fun subscriptionIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptionIds = mapped
    }

    /**
     * @param value Enum of the selector type.
     * Expected value is 'Query'.
     */
    @JvmName("fmtrwqkggjyxwevi")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): QuerySelectorArgs = QuerySelectorArgs(
        filter = filter,
        id = id ?: throw PulumiNullFieldException("id"),
        queryString = queryString ?: throw PulumiNullFieldException("queryString"),
        subscriptionIds = subscriptionIds ?: throw PulumiNullFieldException("subscriptionIds"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
