@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.TargetReferenceArgs.builder
import com.pulumi.azurenative.chaos.kotlin.enums.TargetReferenceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Model that represents a reference to a Target in the selector.
 * @property id String of the resource ID of a Target resource.
 * @property type Enum of the Target reference type.
 */
public data class TargetReferenceArgs(
    public val id: Output<String>,
    public val type: Output<Either<String, TargetReferenceType>>,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.TargetReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.TargetReferenceArgs =
        com.pulumi.azurenative.chaos.inputs.TargetReferenceArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TargetReferenceArgs].
 */
@PulumiTagMarker
public class TargetReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var type: Output<Either<String, TargetReferenceType>>? = null

    /**
     * @param value String of the resource ID of a Target resource.
     */
    @JvmName("ixgjkpahpcsudvaj")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Enum of the Target reference type.
     */
    @JvmName("eihjrtnspvwghhff")
    public suspend fun type(`value`: Output<Either<String, TargetReferenceType>>) {
        this.type = value
    }

    /**
     * @param value String of the resource ID of a Target resource.
     */
    @JvmName("gmnjrfohyuffpbpl")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Enum of the Target reference type.
     */
    @JvmName("spmwnglqehxecpai")
    public suspend fun type(`value`: Either<String, TargetReferenceType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Enum of the Target reference type.
     */
    @JvmName("hgggpcbkrorhrmfg")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TargetReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Enum of the Target reference type.
     */
    @JvmName("yhhmgdrfsluivflp")
    public fun type(`value`: TargetReferenceType) {
        val toBeMapped = Either.ofRight<String, TargetReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TargetReferenceArgs = TargetReferenceArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
