@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Model that represents a discrete action.
 * @property name String that represents a Capability URN.
 * @property parameters List of key value pairs.
 * @property selectorId String that represents a selector.
 * @property type Enum that discriminates between action models.
 * Expected value is 'discrete'.
 */
public data class DiscreteActionResponse(
    public val name: String,
    public val parameters: List<KeyValuePairResponse>,
    public val selectorId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.DiscreteActionResponse):
            DiscreteActionResponse = DiscreteActionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.chaos.kotlin.outputs.KeyValuePairResponse.Companion.toKotlin(args0)
                })
            }),
            selectorId = javaType.selectorId(),
            type = javaType.type(),
        )
    }
}
