@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * PrivateAccesses tracked resource.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property privateEndpointConnections A readonly collection of private endpoint connection. Currently only one endpoint connection is supported.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetPrivateAccessResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.GetPrivateAccessResult):
            GetPrivateAccessResult = GetPrivateAccessResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.chaos.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.chaos.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
