@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Model that represents a Target resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location Location of the target resource.
 * @property name The name of the resource
 * @property properties The properties of the target resource.
 * @property systemData The system metadata of the target resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetTargetResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: Any,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.GetTargetResult):
            GetTargetResult = GetTargetResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.chaos.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
