@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A map to describe the settings of an action.
 * @property key The name of the setting for the action.
 * @property value The value of the setting for the action.
 */
public data class KeyValuePairResponse(
    public val key: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.KeyValuePairResponse):
            KeyValuePairResponse = KeyValuePairResponse(
            key = javaType.key(),
            `value` = javaType.`value`(),
        )
    }
}
