@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Model that represents a list selector.
 * @property filter Model that represents available filter types that can be applied to a targets list.
 * @property id String of the selector ID.
 * @property targets List of Target references.
 * @property type Enum of the selector type.
 * Expected value is 'List'.
 */
public data class ListSelectorResponse(
    public val filter: SimpleFilterResponse? = null,
    public val id: String,
    public val targets: List<TargetReferenceResponse>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.ListSelectorResponse):
            ListSelectorResponse = ListSelectorResponse(
            filter = javaType.filter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.chaos.kotlin.outputs.SimpleFilterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            targets = javaType.targets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.chaos.kotlin.outputs.TargetReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
