@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Model that represents a step in the Experiment resource.
 * @property branches List of branches.
 * @property name String of the step name.
 */
public data class StepResponse(
    public val branches: List<BranchResponse>,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.StepResponse): StepResponse =
            StepResponse(
                branches = javaType.branches().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.chaos.kotlin.outputs.BranchResponse.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name(),
            )
    }
}
