@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.DeploymentPropertiesResponse
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.DeploymentPropertiesResponse.Companion.toKotlin as deploymentPropertiesResponseToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Deployment].
 */
@PulumiTagMarker
public class DeploymentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeploymentArgs = DeploymentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeploymentArgsBuilder.() -> Unit) {
        val builder = DeploymentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Deployment {
        val builtJavaResource =
            com.pulumi.azurenative.cognitiveservices.Deployment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Deployment(builtJavaResource)
    }
}

/**
 * Cognitive Services account deployment.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-10-01.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### PutDeployment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.CognitiveServices.Deployment("deployment", new()
 *     {
 *         AccountName = "accountName",
 *         DeploymentName = "deploymentName",
 *         Properties = new AzureNative.CognitiveServices.Inputs.DeploymentPropertiesArgs
 *         {
 *             Model = new AzureNative.CognitiveServices.Inputs.DeploymentModelArgs
 *             {
 *                 Format = "OpenAI",
 *                 Name = "ada",
 *                 Version = "1",
 *             },
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *         Sku = new AzureNative.CognitiveServices.Inputs.SkuArgs
 *         {
 *             Capacity = 1,
 *             Name = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewDeployment(ctx, "deployment", &cognitiveservices.DeploymentArgs{
 * 			AccountName:    pulumi.String("accountName"),
 * 			DeploymentName: pulumi.String("deploymentName"),
 * 			Properties: cognitiveservices.DeploymentPropertiesResponse{
 * 				Model: &cognitiveservices.DeploymentModelArgs{
 * 					Format:  pulumi.String("OpenAI"),
 * 					Name:    pulumi.String("ada"),
 * 					Version: pulumi.String("1"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Sku: &cognitiveservices.SkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.Deployment;
 * import com.pulumi.azurenative.cognitiveservices.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .accountName("accountName")
 *             .deploymentName("deploymentName")
 *             .properties(Map.of("model", Map.ofEntries(
 *                 Map.entry("format", "OpenAI"),
 *                 Map.entry("name", "ada"),
 *                 Map.entry("version", "1")
 *             )))
 *             .resourceGroupName("resourceGroupName")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "Standard")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:Deployment deploymentName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/deployments/{deploymentName}
 * ```
 */
public class Deployment internal constructor(
    override val javaResource: com.pulumi.azurenative.cognitiveservices.Deployment,
) : KotlinCustomResource(javaResource, DeploymentMapper) {
    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of Cognitive Services account deployment.
     */
    public val properties: Output<DeploymentPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                deploymentPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The resource model definition representing SKU
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DeploymentMapper : ResourceMapper<Deployment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cognitiveservices.Deployment::class == javaResource::class

    override fun map(javaResource: Resource): Deployment = Deployment(
        javaResource as
            com.pulumi.azurenative.cognitiveservices.Deployment,
    )
}

/**
 * @see [Deployment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Deployment].
 */
public suspend fun deployment(name: String, block: suspend DeploymentResourceBuilder.() -> Unit):
    Deployment {
    val builder = DeploymentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Deployment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deployment(name: String): Deployment {
    val builder = DeploymentResourceBuilder()
    builder.name(name)
    return builder.build()
}
