@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.CommitmentPeriodArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cognitive Services account commitment period.
 * @property count Commitment period commitment count.
 * @property tier Commitment period commitment tier.
 */
public data class CommitmentPeriodArgs(
    public val count: Output<Int>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.CommitmentPeriodArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.CommitmentPeriodArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.CommitmentPeriodArgs.builder()
            .count(count?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CommitmentPeriodArgs].
 */
@PulumiTagMarker
public class CommitmentPeriodArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var tier: Output<String>? = null

    /**
     * @param value Commitment period commitment count.
     */
    @JvmName("yscflyjlyaawokkb")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value Commitment period commitment tier.
     */
    @JvmName("chtfagrpgasvujhs")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value Commitment period commitment count.
     */
    @JvmName("vpkiidngkwyckoty")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value Commitment period commitment tier.
     */
    @JvmName("flwtnjnswvnpovus")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): CommitmentPeriodArgs = CommitmentPeriodArgs(
        count = count,
        tier = tier,
    )
}
