@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.DeploymentModelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of Cognitive Services account deployment model.
 * @property format Deployment model format.
 * @property name Deployment model name.
 * @property source Optional. Deployment model source ARM resource ID.
 * @property version Optional. Deployment model version. If version is not specified, a default version will be assigned. The default version is different for different models and might change when there is new version available for a model. Default version for a model could be found from list models API.
 */
public data class DeploymentModelArgs(
    public val format: Output<String>? = null,
    public val name: Output<String>? = null,
    public val source: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.DeploymentModelArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.DeploymentModelArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.DeploymentModelArgs.builder()
            .format(format?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentModelArgs].
 */
@PulumiTagMarker
public class DeploymentModelArgsBuilder internal constructor() {
    private var format: Output<String>? = null

    private var name: Output<String>? = null

    private var source: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Deployment model format.
     */
    @JvmName("eqsmintfnuxiqngj")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value Deployment model name.
     */
    @JvmName("sqioyjiqjvvosgaq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Optional. Deployment model source ARM resource ID.
     */
    @JvmName("qmoomkxmbdvtvntr")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Optional. Deployment model version. If version is not specified, a default version will be assigned. The default version is different for different models and might change when there is new version available for a model. Default version for a model could be found from list models API.
     */
    @JvmName("kjdiyxmslsvhmaqx")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Deployment model format.
     */
    @JvmName("wnubdjcbvgcredxl")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Deployment model name.
     */
    @JvmName("neycrvjdhxipvrjm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Optional. Deployment model source ARM resource ID.
     */
    @JvmName("qencikxcjstuaoaw")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Optional. Deployment model version. If version is not specified, a default version will be assigned. The default version is different for different models and might change when there is new version available for a model. Default version for a model could be found from list models API.
     */
    @JvmName("xukwpekyqiuxiiac")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): DeploymentModelArgs = DeploymentModelArgs(
        format = format,
        name = name,
        source = source,
        version = version,
    )
}
